/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.cli.cmd4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.swarg.cli.cmd4j.Arguments;
import org.swarg.cli.cmd4j.CommandEntry;
import org.swarg.cli.cmd4j.CommandsMeta;
import org.swarg.cli.cmd4j.Input;
import org.swarg.cli.cmd4j.Output;

public class CliFlow {
    protected String originalCommandLine;
    protected Arguments args;
    protected Consumer<String> view;
    protected CommandsMeta cmeta;
    protected List<String> path;
    protected Map<String, Object> ctx;

    public CliFlow() {
    }

    public CliFlow(String line) {
        this.parse(line);
    }

    public CliFlow(String[] args) {
        this.withArgs(args);
    }

    public CliFlow parse(String line) {
        this.originalCommandLine = line == null ? "" : line;
        this.withArgs(this.originalCommandLine.split(" "));
        return this;
    }

    public CliFlow withArgs(String[] args) {
        this.args = new Arguments(args);
        return this;
    }

    public CliFlow withView(Consumer<String> view) {
        this.view = view;
        return this;
    }

    public CliFlow withVar(String varname, Object value) {
        this.getCtx().put(varname, value);
        return this;
    }

    public Map<String, Object> getCtx() {
        if (this.ctx == null) {
            this.ctx = new HashMap<String, Object>();
        }
        return this.ctx;
    }

    public CommandsMeta commands() {
        this.cmeta = new CommandsMeta(this);
        return this.cmeta;
    }

    public Input getInput() {
        return new Input(this);
    }

    public Output getOutput() {
        return new Output(this.view);
    }

    public void dispatchInput() {
        Output output = this.getOutput();
        String cmd = this.args.arg(0);
        if (cmd == null || "help".equalsIgnoreCase(cmd) || "".equals(cmd)) {
            this.cmeta.buildHelpBranch(output);
        } else {
            assert (cmd != null);
            CommandEntry ce = this.cmeta.findCommandHandler(cmd);
            if (ce == null) {
                output.append("Unkwnon command: '{}'\n", cmd);
            } else if (ce.handler == null) {
                output.append("Not Found handler for command: '{}'\n", cmd);
            } else {
                this.args.shift(1);
                if (this.path == null) {
                    this.path = new ArrayList<String>();
                }
                this.path.add(ce.name);
                this.cmeta = null;
                Input input = this.getInput();
                this.performCommand(ce.handler, input, output);
            }
        }
        output.flush();
    }

    protected void performCommand(BiConsumer<Input, Output> handler, Input input, Output output) {
        try {
            handler.accept(input, output);
        }
        catch (IllegalArgumentException ex) {
            input.buildHelp(this.path, ex, output);
        }
    }

    protected Arguments getArgs() {
        return this.args;
    }
}

