/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.cli.cmd4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.swarg.cli.cmd4j.CliFlow;
import org.swarg.cli.cmd4j.CommandEntry;
import org.swarg.cli.cmd4j.Input;
import org.swarg.cli.cmd4j.Output;

public class CommandsMeta {
    protected CliFlow flow;
    protected Map<String, CommandEntry> commands;
    protected List<String> orderedCommands;
    protected String desc;
    protected boolean insideCommand;

    public CommandsMeta(CliFlow flow) {
        this.flow = flow;
    }

    public CommandsMeta desc(String text) {
        this.desc = text;
        return this;
    }

    protected void clear() {
        this.desc = null;
    }

    public CommandsMeta cmd(String name, BiConsumer<Input, Output> handler) {
        return this.cmd(name, null, handler);
    }

    public CommandsMeta cmd(String name, String shortname, BiConsumer<Input, Output> handler) {
        if (this.commands == null) {
            this.commands = new HashMap<String, CommandEntry>();
            this.orderedCommands = new ArrayList<String>();
        }
        Objects.requireNonNull(handler);
        CommandEntry ce = new CommandEntry(name, shortname, handler, this.desc);
        this.commands.put(name, ce);
        this.commands.put(shortname, ce);
        this.orderedCommands.add(name);
        this.clear();
        return this;
    }

    protected CommandEntry findCommandHandler(String name) {
        if (name != null && this.commands != null) {
            return this.commands.get(name);
        }
        return null;
    }

    public void run() {
        this.flow.dispatchInput();
    }

    public void buildHelpBranch(Output o) {
        StringBuilder sb = o.clear().sb();
        if (this.commands != null) {
            for (String name : this.orderedCommands) {
                CommandEntry ce0 = this.commands.get(name);
                sb.append(ce0.shortname).append('|').append(ce0.name);
                sb.append("  -  ");
                sb.append(ce0.desc);
                sb.append('\n');
            }
        } else {
            sb.append("there are no declared commands at the current level");
        }
    }
}

