/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.cli.cmd4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.swarg.cli.cmd4j.Arguments;
import org.swarg.cli.cmd4j.CliFlow;
import org.swarg.cli.cmd4j.CommandsMeta;
import org.swarg.cli.cmd4j.InputEntry;
import org.swarg.cli.cmd4j.InputMeta;
import org.swarg.cli.cmd4j.Output;
import org.swarg.cli.cmd4j.Util;

public class Input {
    public static boolean debug = true;
    protected CliFlow flow;
    protected Arguments args;
    protected InputMeta meta;
    protected List<String> errors;

    public Input(CliFlow flow) {
        this.flow = Objects.requireNonNull(flow);
        this.args = Objects.requireNonNull(flow.getArgs());
        this.meta = new InputMeta(this.args.getArgumentIndex());
    }

    public Input(Arguments args) {
        this.args = Objects.requireNonNull(args);
        this.meta = new InputMeta(args.getArgumentIndex());
        this.flow = null;
    }

    public Input usage(String usageExample) {
        this.meta.usageExample = this.meta.usageExample != null ? this.meta.usageExample + '\n' + usageExample : usageExample;
        return this;
    }

    public Input desc(String text) {
        this.meta.desc = this.meta.desc != null && text != null && "".equals(text) ? this.meta.desc + "\n" + text : text;
        return this;
    }

    public Input desc(String text, String tag) {
        this.desc(text);
        this.meta.tag = tag;
        return this;
    }

    public Input tag(String text) {
        this.meta.tag = text;
        return this;
    }

    public Input optional() {
        this.meta.required = false;
        return this;
    }

    public Input required() {
        this.meta.required = true;
        return this;
    }

    public Input def(Object value) {
        this.meta.required = false;
        this.meta.defaultValue = value;
        return this;
    }

    public CommandsMeta subcommands() {
        return this.flow.commands();
    }

    public void buildHelp(List<String> cpath, Throwable t, Output o) {
        o.clear();
        if (t != null) {
            o.append(t.getMessage()).append("\n");
        }
        this.meta.buildUsage(cpath, this, o);
    }

    public StringBuilder appendCommandPath(StringBuilder sb) {
        if (this.flow != null && sb != null) {
            this.meta.appendCommandName(this.flow.path, sb);
        }
        return sb;
    }

    protected List<InputEntry> getExpectedInput() {
        if (this.meta.expectedInput == null) {
            this.meta.expectedInput = new ArrayList<InputEntry>();
        }
        return this.meta.expectedInput;
    }

    protected InputEntry getLastInputEntry() {
        if (this.meta == null || this.meta.expectedInput == null || this.meta.expectedInput.isEmpty()) {
            return null;
        }
        return this.meta.expectedInput.get(this.meta.expectedInput.size() - 1);
    }

    protected Object getArgDefaultValue() {
        InputEntry e = this.getLastInputEntry();
        return e == null ? null : e.defaultValue;
    }

    protected boolean isFirstArgument() {
        return this.meta.firstArgIndex == this.args.getArgumentIndex();
    }

    protected boolean isRequiredArg() {
        boolean isRequired = this.meta.pullRequired();
        InputEntry ie = this.meta.getLastInputEntry();
        if (isRequired && ie != null && !ie.isRequired()) {
            isRequired = false;
        }
        return isRequired;
    }

    public boolean hasMissedArg() {
        throw new IllegalStateException("Not implemented yet");
    }

    public boolean hasArg() {
        return this.args != null && this.args.hasArg();
    }

    protected Object pullArg0(Class<?> expType) {
        Object value;
        String originalValue;
        String arg;
        boolean required;
        block10: {
            required = this.isRequiredArg();
            boolean isFirstArg = this.isFirstArgument();
            originalValue = arg = this.args.pullArg();
            if (arg == null && required && !this.meta.hasMissedMandatoryArg) {
                this.meta.hasMissedMandatoryArg = true;
            }
            if (arg != null && isFirstArg && "help".equalsIgnoreCase(arg)) {
                this.meta.setHelpRequest(true);
                arg = null;
            }
            value = null;
            try {
                if (arg == null && required) {
                    ++this.meta.inputErrors;
                }
                if (expType == String.class) {
                    value = arg;
                    break block10;
                }
                if (expType == Integer.class) {
                    value = Integer.parseInt(arg);
                    break block10;
                }
                if (expType == Long.class) {
                    value = Long.parseLong(arg);
                    break block10;
                }
                if (expType == Double.class) {
                    value = Double.parseDouble(arg);
                    break block10;
                }
                if (expType == Boolean.class) {
                    value = arg == null ? null : this.isTrue(arg);
                    break block10;
                }
                throw new IllegalArgumentException("Unsupported type: " + expType);
            }
            catch (Exception e) {
                ++this.meta.inputErrors;
            }
        }
        Class<Object> gotType = value == null ? (arg != null ? String.class : null) : value.getClass();
        this.getExpectedInput().add(new InputEntry(this.meta, required, expType, gotType, originalValue));
        this.meta.clearPerArgData();
        return value;
    }

    public String pullArg() {
        String arg = (String)this.pullArg0(String.class);
        return arg != null ? arg : (String)this.getArgDefaultValue();
    }

    public Integer pullArgI() {
        Integer arg = (Integer)this.pullArg0(Integer.class);
        return arg != null ? arg : (Integer)this.getArgDefaultValue();
    }

    public Long pullArgL() {
        Long arg = (Long)this.pullArg0(Long.class);
        return arg != null ? arg : (Long)this.getArgDefaultValue();
    }

    public Double pullArgD() {
        Double arg = (Double)this.pullArg0(Double.class);
        return arg != null ? arg : (Double)this.getArgDefaultValue();
    }

    public Boolean pullArgBool() {
        Boolean arg = (Boolean)this.pullArg0(Boolean.class);
        return arg != null ? arg : (Boolean)this.getArgDefaultValue();
    }

    private Boolean isTrue(String s) {
        return "true".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s);
    }

    public Object getCtxVar(String name, Class<?> expectedClass) {
        boolean castable;
        if (this.flow == null) {
            return null;
        }
        Object o = this.flow.getCtx().get(name);
        if (o == null) {
            return null;
        }
        Class<?> cls = o.getClass();
        boolean bl = castable = expectedClass.isAssignableFrom(cls) || expectedClass == Byte.TYPE && cls == Byte.class || expectedClass == Short.TYPE && cls == Short.class || expectedClass == Integer.TYPE && cls == Integer.class || expectedClass == Long.TYPE && cls == Long.class || expectedClass == Double.TYPE && cls == Double.class || expectedClass == Float.TYPE && cls == Float.class || expectedClass == Boolean.TYPE && cls == Boolean.class;
        if (!castable) {
            return null;
        }
        return o;
    }

    public String pullArgsAsLine() {
        StringBuilder sb = new StringBuilder();
        while (this.args.hasArg()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.pullArg());
        }
        return sb.toString();
    }

    public boolean isInputValid() {
        try {
            this.validateInput();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validateInput() {
        if (this.meta.isHelpRequest() || this.args.isHelp()) {
            throw new IllegalArgumentException("help request");
        }
        if (this.meta.inputErrors > 0) {
            throw new IllegalArgumentException("input errors");
        }
        if (this.args.hasArg()) {
            throw new IllegalArgumentException("unexpected argument");
        }
        if (this.meta.hasMissedMandatoryArg) {
            throw new IllegalArgumentException("has missed mandatory arguments");
        }
    }

    public void showHelp(Output output) {
        this.buildHelp(null, null, output);
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        return this.errors;
    }

    public CliFlow getFlow() {
        return this.flow;
    }

    public boolean isInteger(String s) {
        return Util.isInteger(s);
    }
}

