/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.cli.cmd4j;

import java.util.List;
import org.swarg.cli.cmd4j.Arguments;
import org.swarg.cli.cmd4j.Input;
import org.swarg.cli.cmd4j.InputEntry;
import org.swarg.cli.cmd4j.Output;
import org.swarg.cli.cmd4j.Util;

public class InputMeta {
    protected String usageExample;
    protected List<InputEntry> expectedInput;
    protected boolean hasMissedMandatoryArg;
    protected boolean helpRequest;
    protected int firstArgIndex;
    protected int inputErrors;
    protected String desc;
    protected String tag;
    protected Object defaultValue;
    protected boolean required;

    public InputMeta(int firstArgIndex) {
        this.firstArgIndex = firstArgIndex;
        this.required = true;
    }

    public void clearPerArgData() {
        this.desc = null;
        this.tag = null;
        this.defaultValue = null;
        this.required = true;
    }

    public boolean pullRequired() {
        boolean f = this.required;
        this.required = true;
        return f;
    }

    public InputEntry getLastInputEntry() {
        if (this.expectedInput != null && !this.expectedInput.isEmpty()) {
            return this.expectedInput.get(this.expectedInput.size() - 1);
        }
        return null;
    }

    protected void buildArgumentErrors(StringBuilder sb) {
        if (this.expectedInput == null || this.inputErrors < 1) {
            return;
        }
        for (int i = 0; i < this.expectedInput.size(); ++i) {
            InputEntry e = this.expectedInput.get(i);
            if (e.gotType == null) {
                if (!e.required) continue;
                sb.append("No Required Argument#").append(i + 1);
                Util.appendNotNull(sb, e.tag).append('\n');
                continue;
            }
            if (e.expType == null || e.expType == e.gotType) continue;
            sb.append("Argument#").append(i + 1);
            sb.append(" expected type: ");
            sb.append(e.expType.getSimpleName());
            sb.append(" got: (");
            if (e.gotType != null) {
                sb.append(e.gotType.getSimpleName());
            } else {
                sb.append("null");
            }
            sb.append(") ").append(e.originalValue);
            sb.append('\n');
        }
    }

    protected void buildUsage(List<String> cpath, Input input, Output output) {
        List<InputEntry> expectedArgs;
        Arguments args = input.args;
        StringBuilder sb = output.sb();
        if (args.hasArg() && !this.helpRequest && !args.isHelp()) {
            sb.append("unexpected argument: '").append(args.arg(0)).append("'\n");
        }
        if ((expectedArgs = this.expectedInput) != null && !expectedArgs.isEmpty()) {
            int n;
            if (!this.helpRequest) {
                this.buildArgumentErrors(output.sb());
            }
            sb.append("Usage:\n    ");
            if (cpath != null && !cpath.isEmpty()) {
                this.appendCommandName(cpath, sb).append(' ');
            }
            for (n = 0; n < expectedArgs.size(); ++n) {
                this.appendArgName(expectedArgs.get(n), n, sb);
            }
            sb.append("\nArguments:\n");
            for (n = 0; n < this.expectedInput.size(); ++n) {
                this.appendArgDesc(this.expectedInput.get(n), n, sb);
            }
            if (input.meta != null && input.meta.usageExample != null) {
                sb.append("\nUsage Example:\n");
                sb.append(input.meta.usageExample).append('\n');
            }
        } else if (cpath != null && !cpath.isEmpty()) {
            this.appendCommandName(cpath, sb.append("Usage:\n    ")).append('\n');
        }
    }

    protected StringBuilder appendCommandName(List<String> cpath, StringBuilder sb) {
        for (String cmdname : cpath) {
            sb.append(cmdname).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    protected void appendArgName(InputEntry e, int n, StringBuilder sb) {
        String name = e.tag != null ? e.tag : "arg" + (n + 1);
        String otag = "<";
        String ctag = ">";
        if (!e.required) {
            otag = "[";
            ctag = "]";
        }
        if (n > 0) {
            sb.append(' ');
        }
        sb.append(otag).append(name).append(ctag);
    }

    protected void appendArgDesc(InputEntry e, int n, StringBuilder sb) {
        sb.append(n);
        sb.append(!e.required ? "*" : " ");
        sb.append(Util.v2s(e.tag)).append("  -  ");
        sb.append(Util.v2s(e.desc)).append('\n');
    }

    public int getFirstArgIndex() {
        return this.firstArgIndex;
    }

    public List<InputEntry> getExpectedInput() {
        return this.expectedInput;
    }

    public boolean isHasMissedMandatoryArg() {
        return this.hasMissedMandatoryArg;
    }

    public int getInputErrors() {
        return this.inputErrors;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getTag() {
        return this.tag;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setHelpRequest(boolean b) {
        this.helpRequest = b;
    }

    public boolean isHelpRequest() {
        return this.helpRequest;
    }
}

