/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.cli.cmd4j;

import java.util.function.Consumer;
import org.swarg.cli.cmd4j.Util;

public class Output {
    protected StringBuilder sb;
    protected Consumer<String> view;

    public Output(Consumer<String> view) {
        if (view == null) {
            view = System.out::println;
        }
        this.view = view;
        this.sb = new StringBuilder();
    }

    public StringBuilder sb() {
        return this.sb;
    }

    public String content() {
        return this.sb.toString();
    }

    public boolean hasContent() {
        return this.sb.length() > 0;
    }

    public Output clear() {
        this.sb.setLength(0);
        return this;
    }

    public Output flush() {
        this.view.accept(this.sb.toString());
        this.sb.setLength(0);
        return this;
    }

    public Output append(String line) {
        this.sb.append(line);
        return this;
    }

    public Output append(char ch) {
        this.sb.append(ch);
        return this;
    }

    public Output append(int n) {
        this.sb.append(n);
        return this;
    }

    public Output append(long n) {
        this.sb.append(n);
        return this;
    }

    public Output append(double n) {
        this.sb.append(n);
        return this;
    }

    public Output append(Object obj) {
        this.sb.append(obj);
        return this;
    }

    public Output append(String format, Object ... args) {
        Util.fmt(this.sb, format, args);
        return this;
    }

    public Output say(String message) {
        this.sb.append(message).append('\n');
        return this.flush();
    }

    public Output fsay(String format, Object ... args) {
        return this.append(format, args).append('\n').flush();
    }

    public Output error(String message) {
        this.sb.append("[ERROR] ").append(message).append('\n');
        return this;
    }

    public Output error(String format, Object ... args) {
        Util.fmt(this.sb.append("[ERROR] "), format, args).append('\n');
        return this;
    }
}

