/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.swarg.darkai.FlatDarkaiLaf;
import org.swarg.tonargorn.launcher.Config;
import org.swarg.tonargorn.launcher.Installer;
import org.swarg.tonargorn.launcher.MainFrame;
import org.swarg.tonargorn.launcher.utils.SystemInfo;

public class App {
    public static void main(String[] args) {
        if (SystemInfo.isMacOS) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", "FlatLaf Demo");
            System.setProperty("apple.awt.application.appearance", "system");
        }
        if (SystemInfo.isLinux) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(new FlatDarkaiLaf());
            }
            catch (Exception ex) {
                System.err.println("Failed to initialize FlatDarkaiLaF");
            }
            Config config = new Config();
            Installer installer = new Installer(config);
            MainFrame frame = new MainFrame(config, installer);
            frame.pack();
            frame.setVisible(true);
            frame.moveCenter();
        });
    }
}

