/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.swarg.tonargorn.launcher.utils.BaseUtils;
import org.swarg.tonargorn.launcher.utils.Log;
import org.swarg.tonargorn.launcher.utils.SystemInfo;

public class Config {
    public static final String P_GAMEDIR = "GameDir";
    protected Path configFile = Config.getConfigFile();
    protected Properties prop = new Properties();
    protected boolean showGameOutput;

    public Config() {
        this.reload();
    }

    public static Path getConfigFile() {
        String appData;
        String s = File.separator;
        String home = System.getProperty("user.home", "");
        String dir = SystemInfo.isWindows ? ((appData = System.getenv("APPDATA")) != null && !appData.isEmpty() ? appData + s + "." + "tonargorn" : home + s + "." + "tonargorn") : (SystemInfo.isLinux ? home + "/.config/" + "tonargorn" : (SystemInfo.isMacOS ? home + s + "." + "tonargorn" : home + s + "tonargorn"));
        return Paths.get(dir + s + "launcher.config", new String[0]);
    }

    public String getSoftDir() {
        String home;
        String path = home = System.getProperty("user.home", "");
        if (SystemInfo.isWindows) {
            String appData = System.getenv("APPDATA");
            if (appData != null) {
                path = appData;
            }
        } else if (SystemInfo.isLinux) {
            path = home + "/.local/share";
        }
        return path;
    }

    protected String getDefaultGameDir() {
        String sep = File.separator;
        String path = this.getSoftDir();
        path = path + sep + "tonargorn" + sep;
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config reload() {
        InputStream is = null;
        try {
            this.prop.clear();
            Log.info(this.configFile);
            if (!Files.exists(this.configFile, new LinkOption[0])) {
                Path path = this.configFile.getParent();
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    Files.write(this.configFile, new byte[0], new OpenOption[0]);
                    Log.info("Initialize config file at ", this.configFile);
                }
                catch (IOException e) {
                    Log.err("Cannot create dirs for config", e);
                    System.exit(1);
                }
            }
            is = Files.newInputStream(this.configFile, new OpenOption[0]);
            this.prop.load(is);
            this.checkDefaults();
        }
        catch (Exception e) {
            Log.err("reload", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    public boolean save() {
        try {
            this.prop.store(new FileOutputStream(this.configFile.toFile()), null);
            return true;
        }
        catch (IOException e) {
            Log.err(e);
            return false;
        }
    }

    private void checkDefaults() {
        String gameDir = this.prop.getProperty(P_GAMEDIR);
        if (gameDir == null || gameDir.isEmpty()) {
            this.prop.setProperty(P_GAMEDIR, this.getDefaultGameDir());
        }
    }

    public boolean set(String key, String value) {
        if (key != null && !key.isEmpty()) {
            this.prop.setProperty(key, value);
            return true;
        }
        return false;
    }

    public String get(String key) {
        if (key != null && !key.isEmpty()) {
            return this.prop.getProperty(key);
        }
        return null;
    }

    public String getGameDir() {
        String dir = this.get(P_GAMEDIR);
        if (dir == null || dir.isEmpty()) {
            dir = this.getDefaultGameDir();
            this.prop.setProperty(P_GAMEDIR, dir);
        }
        return dir;
    }

    public Path getGameSettingsFile(String dir) {
        String string = dir = dir == null || "".equals(dir) ? this.getGameDir() : dir;
        if (dir != null && dir.startsWith("~")) {
            dir = System.getProperty("user.home") + dir.substring(1);
        }
        String[] subpath = new String[]{"userdata", "voxygen", "settings.ron"};
        return Paths.get(dir, subpath).toAbsolutePath();
    }

    public Path getGameSettingsFile() {
        return this.getGameSettingsFile(null);
    }

    public String setGameDir(String dir) {
        if (dir == null || dir.isEmpty()) {
            dir = this.getDefaultGameDir();
        }
        this.prop.setProperty(P_GAMEDIR, dir);
        return dir;
    }

    public String getTitle() {
        String title = this.prop.getProperty("CustomTitle");
        if (title == null || title.isEmpty()) {
            title = "Tonargorn-Launcher - 0.9.2";
        }
        return title;
    }

    public String getGameUpateCenterUrl() {
        String url = this.prop.getProperty("CustomGameSrcUrl");
        if (url == null || url.isEmpty()) {
            url = "https://tonargorn.ru/files/";
        }
        return url;
    }

    public String getOSArch() {
        String os_arch = this.prop.getProperty("CustomOSArch");
        if (os_arch == null || os_arch.isEmpty()) {
            os_arch = SystemInfo.getOSArch();
        }
        return os_arch;
    }

    public String getLauncherChkUrl() {
        return this.getGameUpateCenterUrl() + "/launcher.chk";
    }

    public String getLauncherUrl() {
        return this.getGameUpateCenterUrl() + "Tonargorn-Launcher" + ".jar";
    }

    public String getGameClientCheckListUrl() {
        return this.getGameUpateCenterUrl() + "/" + this.getOSArch() + ".chk";
    }

    public String getAssetsCheckListUrl() {
        return this.getGameUpateCenterUrl() + "/assets.chk";
    }

    public String getGameClientZipUrl() {
        return this.getGameUpateCenterUrl() + "/" + this.getOSArch() + ".zip";
    }

    public String getGameAssetsZipUrl() {
        return this.getGameUpateCenterUrl() + "/assets.zip";
    }

    public File getLauncherChkAbsPath() {
        return new File(this.getGameDir() + File.separator + "launcher.chk");
    }

    public File getGameClientChkAbsPath() {
        return new File(this.getGameDir() + File.separator + this.getOSArch() + ".chk");
    }

    public File getGameAssetsDirAbsPath() {
        return new File(this.getGameDir() + File.separator + "assets");
    }

    public File getGameAssetsChkAbsPath() {
        return new File(this.getGameDir() + File.separator + "assets.chk");
    }

    public File getGameAssetsOwnChkAbsPath() {
        return new File(this.getGameDir() + File.separator + "assetszip.chk");
    }

    public boolean ensureGameDirExists() {
        try {
            Path path = Paths.get(this.getGameDir(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
        }
        catch (IOException e) {
            Log.err(e);
            return false;
        }
    }

    public void clearGameDir(List<String> errors) {
        File[] fa;
        String gd = this.getGameDir();
        if (gd == null || gd.isEmpty() || "/".equals(gd)) {
            return;
        }
        File dir = new File(gd);
        for (File f : fa = dir.listFiles()) {
            String fn = f.getName();
            if ("userdata".equals(fn) || "backups".equals(fn)) continue;
            Log.info("Delete: " + f.getName());
            if (f.isDirectory()) {
                BaseUtils.deleteDirectory(f);
            } else {
                f.delete();
            }
            if (!f.exists()) continue;
            Log.info("cannot delete: " + f.getName());
            errors.add(f.toString());
        }
    }

    public String getExecutable() {
        StringBuilder sb = new StringBuilder(this.getGameDir());
        sb.append(File.separator).append("tonargorn");
        if (SystemInfo.isWindows) {
            sb.append(".exe");
        }
        return sb.toString();
    }

    public boolean isShowGameOutput() {
        return this.showGameOutput;
    }

    public void setShowGameOutput(boolean showGameOutput) {
        this.showGameOutput = showGameOutput;
    }

    public Path mkFileBackup(Path file) {
        if (file != null && Files.exists(file, new LinkOption[0])) {
            Path copied = file.toAbsolutePath();
            Path target = null;
            int i = 0;
            while (Files.exists(target = Paths.get(copied.toString() + "_bak" + ++i, new String[0]), new LinkOption[0])) {
            }
            try {
                Files.copy(copied, target, StandardCopyOption.REPLACE_EXISTING);
                return target;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

