/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher;

import java.util.function.Consumer;
import org.swarg.cli.cmd4j.CliFlow;
import org.swarg.cli.cmd4j.Input;
import org.swarg.cli.cmd4j.Output;
import org.swarg.tonargorn.launcher.Config;
import org.swarg.tonargorn.launcher.command.ConfCommand;
import org.swarg.tonargorn.launcher.command.DevCommand;
import org.swarg.tonargorn.launcher.utils.Log;

public class Console {
    Config config;
    Consumer<String> append;

    public Console(Config config, Consumer<String> append) {
        this.config = config;
        this.append = append;
    }

    public void handle(String line) {
        if (line == null || line.isEmpty()) {
            Log.debug("command expected");
            return;
        }
        Log.debug("DevConsole", line);
        new CliFlow(line).withView(this::append0).withVar("conf", this.config).commands().desc("show launcher version").cmd("version", "v", Console::version).desc("check command-handler itself").cmd("echo", "e", Console::echo).desc("development tools").cmd("dev", "d", DevCommand::handle).desc("interact with game configuration").cmd("config", "c", ConfCommand::handle).run();
    }

    public void append0(String s) {
        Log.debug(s);
        this.append.accept(s);
    }

    protected static void version(Input q, Output o) {
        Log.debug("cmd ", "0.9.2");
        o.fsay("Launcher version: {}", "0.9.2");
        o.fsay("Java: {} JAVA_HOME: {}", System.getProperty("java.version"), System.getProperty("java.home"));
    }

    protected static void echo(Input q, Output o) {
        String a1 = q.pullArg();
        q.validateInput();
        o.fsay("arg0:{}", a1);
    }
}

