/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.swarg.tonargorn.launcher.Config;
import org.swarg.tonargorn.launcher.Updater;
import org.swarg.tonargorn.launcher.utils.BaseUtils;
import org.swarg.tonargorn.launcher.utils.DownloadTask;
import org.swarg.tonargorn.launcher.utils.DownloaderGUI;
import org.swarg.tonargorn.launcher.utils.Log;
import org.swarg.tonargorn.launcher.utils.SystemInfo;
import org.swarg.tonargorn.launcher.utils.UFileInfo;

public class Installer
implements DownloaderGUI,
PropertyChangeListener {
    private DownloaderGUI gui;
    private Config config;
    protected Map<String, UFileInfo> tasks;
    private StateValue state;
    private String queuedCmd;
    protected Process gameProc;
    public static final String TRY_REINSTALL = "You can try to Clean the Game Dirirectory and re-Install the Game.\nSee the `</>` button and `Clean GameDir`.";

    public Installer(Config config) {
        this.config = config;
        this.tasks = new HashMap<String, UFileInfo>();
        this.state = StateValue.NONE;
        this.queuedCmd = null;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getGameDir() {
        return this.config.getGameDir();
    }

    public void setGui(DownloaderGUI gui) {
        this.gui = gui;
    }

    public DownloaderGUI getGui() {
        return this.gui;
    }

    public void setState(StateValue state) {
        this.state = state;
    }

    public StateValue getState() {
        return this.state;
    }

    public boolean doInstall() {
        Path gamedir = Paths.get(this.config.get("GameDir"), new String[0]);
        if (!Files.exists(gamedir, new LinkOption[0])) {
            try {
                Files.createDirectories(gamedir, new FileAttribute[0]);
            }
            catch (Throwable t) {
                Log.err(t);
            }
        }
        return false;
    }

    public boolean isLauncherUptodate() {
        Log.debug("Installer: Check launcher uptodate");
        Objects.requireNonNull(this.config);
        File check = this.config.getLauncherChkAbsPath();
        boolean isUptodate = false;
        if (check.exists()) {
            List<UFileInfo> checkSumList = BaseUtils.parseCheckList(check);
            try {
                Path path = BaseUtils.getSelfJarPath();
                if (path != null && checkSumList != null && !checkSumList.isEmpty()) {
                    String current = UFileInfo.getMd5Readable(BaseUtils.hashFile(path, "MD5"));
                    String actual = checkSumList.get(0).getMd5Readable();
                    isUptodate = actual != null && actual.equals(current);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Log.debug("Installer: launcher up-to-date: " + isUptodate);
        return isUptodate;
    }

    public boolean isGameInstalled() {
        Log.debug("Installer: Check isGameInstalled");
        boolean b = this.isGameBinariesOK() && this.isGameAssetsOK();
        Log.debug("Installed", b);
        return b;
    }

    public boolean isValidFiles(Path gameDir, List<UFileInfo> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (UFileInfo u : list) {
            Log.debug(u.getMd5Readable() + " " + u.getPath());
            Path path = gameDir.resolve(u.getPath());
            if (Files.exists(path, new LinkOption[0])) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                try {
                    byte[] ba = BaseUtils.hashFile(path, "MD5");
                    if (Arrays.equals(u.getMd5(), ba)) continue;
                    Log.info("Broken File", path);
                    return false;
                }
                catch (Exception e) {
                    Log.err(e);
                    return false;
                }
            }
            Log.debug("File Not Found", path);
            return false;
        }
        return true;
    }

    public boolean isGameBinariesOK() {
        File check;
        Objects.requireNonNull(this.config);
        Log.debug("Installer: check IsGameBinaryOK...");
        Path gameDir = Paths.get(this.getGameDir(), new String[0]);
        boolean valid = false;
        if (Files.exists(gameDir, new LinkOption[0]) && (check = this.config.getGameClientChkAbsPath()).exists()) {
            List<UFileInfo> checkSumList = BaseUtils.parseCheckList(check);
            valid = this.isValidFiles(gameDir, checkSumList);
        }
        Log.debug("Installer: Game-Binaries is: " + (valid ? "OK" : "BAD"));
        return valid;
    }

    public boolean isGameAssetsOK() {
        List<UFileInfo> hasChk;
        Log.debug("Installer: isGameAssetsOK");
        File assetsDir = this.config.getGameAssetsDirAbsPath();
        File assetsChk = this.config.getGameAssetsChkAbsPath();
        File ownAssetsChk = this.config.getGameAssetsOwnChkAbsPath();
        if (!assetsDir.exists()) {
            Log.debug("No assetsDir: " + assetsDir);
            return false;
        }
        if (!assetsChk.exists()) {
            Log.debug("No assets.chk: " + assetsChk);
            return false;
        }
        if (!ownAssetsChk.exists()) {
            Log.debug("No downloaded-assetszip.chk" + ownAssetsChk);
            return false;
        }
        List<UFileInfo> actChk = BaseUtils.parseCheckList(assetsChk);
        if (!BaseUtils.isCheckSumsEquals(actChk, hasChk = BaseUtils.parseCheckList(ownAssetsChk))) {
            Log.debug("Diff checksum of assets.zip");
            return false;
        }
        Log.debug("GameAssets: Dir Exists!");
        File[] fa = assetsDir.listFiles();
        int i = 0;
        for (File file : fa) {
            String s = file.getName();
            Log.debug("GameAssets: Check Dir ", s);
            if (!"common".equals(s) && !"voxygen".equals(s) && !"world".equals(s)) continue;
            ++i;
        }
        Log.debug("GameAssets: Dirs", i);
        return i >= 3;
    }

    public void showCritError(String message) {
        this.gui.show("[ERROR] " + message);
        Log.err(message);
    }

    public void start() {
        Log.debug("Installer.start(InstallBinaryGameFiles)");
        if (!this.config.ensureGameDirExists()) {
            this.showCritError("Cannot Create GameDir at: '" + this.getGameDir() + "'");
            return;
        }
        if (this.state != StateValue.NONE) {
            Log.err("Cannot start the installer. In State", (Object)this.state);
            return;
        }
        if (!this.config.getGameClientChkAbsPath().exists()) {
            this.addTask(this.config.getGameClientCheckListUrl(), StateValue.CHECKLIST);
            this.queueCommand("install");
            return;
        }
        if (!this.isGameBinariesOK()) {
            this.addTask(this.config.getGameClientZipUrl(), StateValue.CLIENT_ZIP);
        } else if (!this.isGameAssetsOK()) {
            this.addTask(this.config.getGameAssetsZipUrl(), StateValue.ASSETS_ZIP);
        }
    }

    public void startUpdateLauncher() {
        if (this.state != StateValue.NONE) {
            Log.err("Cannot update launcher. In State", (Object)this.state);
            return;
        }
        String gameDir = this.config.getGameDir();
        File dir = new File(gameDir + File.separator + "update");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.addTask(dir.toString(), this.config.getLauncherUrl(), StateValue.LAUNCHER);
    }

    public boolean addTask(String dstDir, String url, StateValue newState) {
        if (url != null && !url.isEmpty() && newState != null) {
            this.state = newState;
            UFileInfo ufi = new UFileInfo(url);
            Log.info("Add new task " + url + " to " + dstDir + " : " + (Object)((Object)this.state));
            this.tasks.put(url, ufi);
            DownloadTask task = new DownloadTask(this, dstDir, ufi);
            task.addPropertyChangeListener(this);
            task.execute();
            return true;
        }
        return false;
    }

    public boolean addTask(String url, StateValue newState) {
        return this.addTask(this.config.getGameDir(), url, newState);
    }

    public void queueCommand(String cmd) {
        this.queuedCmd = cmd;
    }

    public UFileInfo removeTask(String task_name) {
        UFileInfo task = this.tasks.remove(task_name);
        return task;
    }

    public void stop() {
        for (UFileInfo u : this.tasks.values()) {
            if (!(u.getParent() instanceof DownloadTask)) continue;
            ((DownloadTask)u.getParent()).cancel(true);
        }
        this.state = StateValue.NONE;
        this.tasks.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("progress")) {
            Integer progress = (Integer)evt.getNewValue();
            if (this.gui != null) {
                this.gui.progress(progress);
            } else {
                Log.info("Progress", progress);
            }
        }
    }

    @Override
    public void show(String message) {
        if (this.gui != null) {
            this.gui.show(message);
        } else {
            Log.info(message);
        }
    }

    @Override
    public void setFileInfo(String name, int size) {
        if (this.gui != null) {
            this.gui.setFileInfo(name, size);
        } else {
            Log.info(name, size);
        }
    }

    @Override
    public void progress(Integer progress) {
    }

    @Override
    public void showError(String message, Throwable err) {
        if (this.gui != null) {
            this.gui.showError(message, err);
        } else {
            Log.err(message, err);
        }
    }

    @Override
    public void done(UFileInfo u, ActionEvent e0) {
        ActionEvent event = null;
        if (this.state == StateValue.LAUNCHER_CHK) {
            event = this.onLauncherChkDone(u);
        } else if (this.state == StateValue.LAUNCHER) {
            event = this.onLauncherJarDone(u);
        } else if (this.state == StateValue.CHECKLIST) {
            event = this.onChecklistDone(u);
        } else if (this.state == StateValue.ASSETS_CHK) {
            event = this.onAssetsChkDone(u);
        } else if (this.state == StateValue.CLIENT_ZIP) {
            event = this.onClientZipDone(u);
        } else if (this.state == StateValue.ASSETS_ZIP) {
            event = this.onAssetsZipDone(u);
        }
        this.removeTask(u.getUrl());
        if (this.gui != null) {
            this.gui.done(u, event);
        }
        if (this.queuedCmd != null && this.state == StateValue.NONE && this.tasks.isEmpty()) {
            this.runPendingCommand();
        }
    }

    private void runPendingCommand() {
        String cmd = this.queuedCmd;
        this.queuedCmd = null;
        Log.debug("applyQueuedCommand: " + cmd);
        if ("install".equals(cmd)) {
            int id = StateValue.INSTALL.ordinal();
            this.gui.done(null, new ActionEvent(this.gui, id, "install"));
        }
    }

    public ActionEvent onLauncherChkDone(UFileInfo u) {
        Log.debug("Downloaded: launcher.chk");
        if (!this.isLauncherUptodate()) {
            int id = StateValue.LAUNCHER.ordinal();
            this.state = StateValue.NONE;
            return new ActionEvent(this.gui, id, null);
        }
        if (!this.config.ensureGameDirExists()) {
            this.showCritError("Cannot create GameDir");
            return null;
        }
        this.addTask(this.config.getGameClientCheckListUrl(), StateValue.CHECKLIST);
        return null;
    }

    public ActionEvent onLauncherJarDone(UFileInfo u) {
        Log.debug("Downloaded launcher.jar");
        Updater.update(BaseUtils.getSelfJarPath(), u);
        return null;
    }

    protected ActionEvent onChecklistDone(UFileInfo u) {
        Log.debug("Downloaded: os-arch.chk");
        this.addTask(this.config.getAssetsCheckListUrl(), StateValue.ASSETS_CHK);
        return null;
    }

    protected ActionEvent onAssetsChkDone(UFileInfo u) {
        Log.debug("Downloaded: assets.chk");
        this.state = StateValue.NONE;
        int id = StateValue.INSTALLED.ordinal();
        String value = String.valueOf(this.isGameInstalled());
        return new ActionEvent(this.gui, id, value);
    }

    protected ActionEvent onClientZipDone(UFileInfo u) {
        Log.debug("Downloaded: client-zip");
        if (!BaseUtils.unzip(u.getPath(), this.getGameDir())) {
            this.showCritError("Cannot unzip the archive with the binary executable");
            this.state = StateValue.NONE;
            return null;
        }
        if (!this.isGameBinariesOK()) {
            this.showCritError("Game binary file(s) is broken!\nYou can try to Clean the Game Dirirectory and re-Install the Game.\nSee the `</>` button and `Clean GameDir`.");
            this.state = StateValue.NONE;
            return null;
        }
        new File(u.getPath()).delete();
        if (this.isGameAssetsOK()) {
            return this.mkEventCanPlay();
        }
        this.addTask(this.config.getGameAssetsZipUrl(), StateValue.ASSETS_ZIP);
        return null;
    }

    protected ActionEvent onAssetsZipDone(UFileInfo u) {
        Log.debug("Downloaded: assets-zip");
        File assetsDir = this.config.getGameAssetsDirAbsPath();
        if (assetsDir.exists()) {
            Log.debug("clean assets Directory");
            BaseUtils.deleteDirectory(assetsDir);
        }
        if (!BaseUtils.unzip(u.getPath(), this.getGameDir())) {
            this.showCritError("Cannot unzip the assets.zip file");
            this.state = StateValue.NONE;
            return null;
        }
        File outfile = this.config.getGameAssetsOwnChkAbsPath();
        BaseUtils.createChkFile(u.getPath(), outfile, "assets.zip");
        new File(u.getPath()).delete();
        if (!this.isGameAssetsOK()) {
            this.showCritError("Assets is Broken!\nYou can try to Clean the Game Dirirectory and re-Install the Game.\nSee the `</>` button and `Clean GameDir`.");
            this.state = StateValue.NONE;
            return null;
        }
        if (!SystemInfo.isWindows) {
            String binary = this.config.getExecutable();
            try {
                File file = new File(binary);
                file.setWritable(false);
                file.setReadable(true);
                file.setExecutable(true);
            }
            catch (Exception e) {
                Log.err("On make file executable", e);
                this.showCritError("Can't make file executable " + binary);
                return null;
            }
        }
        return this.mkEventCanPlay();
    }

    private ActionEvent mkEventCanPlay() {
        this.state = StateValue.CAN_PLAY;
        int id = StateValue.CAN_PLAY.ordinal();
        return new ActionEvent(this.gui, id, "CanPlay");
    }

    public boolean runGame() throws IOException {
        if (this.gameProc != null && this.gameProc.isAlive()) {
            Log.info("the game is already running.");
            return true;
        }
        String cmd = this.config.getExecutable();
        String dir = this.getGameDir();
        Log.info("runGame ", cmd + " at " + dir);
        this.gameProc = new ProcessBuilder(cmd).directory(new File(dir)).redirectErrorStream(true).start();
        Log.info("alive: ", this.gameProc != null ? this.gameProc.isAlive() : false);
        if (this.config.isShowGameOutput()) {
            new Thread(() -> {
                int exitCode = -1;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.gameProc.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Log.info(line);
                    }
                    exitCode = this.gameProc.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.info("exit code: ", exitCode);
            }).start();
        }
        return true;
    }

    public static enum StateValue {
        NONE,
        STOP,
        CHECKLIST,
        INSTALL,
        INSTALLED,
        CLIENT_ZIP,
        ASSETS_CHK,
        ASSETS_ZIP,
        LAUNCHER_CHK,
        LAUNCHER,
        CAN_PLAY;

    }
}

