/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.swarg.tonargorn.launcher.Config;
import org.swarg.tonargorn.launcher.Installer;
import org.swarg.tonargorn.launcher.components.ConfigPanel;
import org.swarg.tonargorn.launcher.components.ImagePanel;
import org.swarg.tonargorn.launcher.components.InstallPanel;
import org.swarg.tonargorn.launcher.components.cli.CliPanel;
import org.swarg.tonargorn.launcher.utils.GuiUtils;
import org.swarg.tonargorn.launcher.utils.Log;

public class MainFrame
extends JFrame
implements ActionListener {
    private final ImagePanel pMain = new ImagePanel();
    private final JPanel pCenter;
    private final CliPanel pCli;
    private final ConfigPanel pConfig;
    private final InstallPanel pInstaller;
    private final JPanel pBar;
    private final JButton bConfig;
    private final JButton bInstall;
    private final JButton bPlay;
    private final JButton bCli;

    public MainFrame(Config config, Installer installer) {
        this.pMain.setLayout(new BorderLayout());
        this.pCenter = new JPanel();
        this.pCenter.setLayout(new BorderLayout());
        this.pCenter.setOpaque(false);
        this.pBar = new JPanel();
        this.pBar.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.2f));
        this.pBar.setLayout(new FlowLayout(0, 64, 10));
        this.bCli = new JButton("</>");
        this.bCli.setPreferredSize(new Dimension(64, 32));
        this.bConfig = new JButton("Config");
        this.bConfig.setPreferredSize(new Dimension(144, 32));
        this.bInstall = new JButton("Install");
        this.bInstall.setPreferredSize(new Dimension(144, 32));
        this.bPlay = new JButton("Play");
        this.bPlay.setPreferredSize(new Dimension(144, 32));
        this.bPlay.requestFocusInWindow();
        this.pBar.add(this.bCli);
        this.pBar.add(this.bConfig);
        this.pBar.add(this.bInstall);
        this.pBar.add(this.bPlay);
        this.bConfig.addActionListener(this);
        this.bInstall.addActionListener(this);
        this.bPlay.addActionListener(this);
        this.bCli.addActionListener(this);
        this.pConfig = new ConfigPanel(this, config);
        this.pConfig.setVisible(false);
        this.pInstaller = new InstallPanel(this, installer);
        this.pInstaller.setVisible(false);
        installer.setGui(this.pInstaller);
        this.pCli = new CliPanel(this, config);
        this.pCli.setVisible(false);
        this.setTitle(config.getTitle());
        this.setDefaultCloseOperation(3);
        MainFrame.setDefaultLookAndFeelDecorated(true);
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(640, 280));
        this.setPreferredSize(new Dimension(1280, 530));
        this.setResizable(false);
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pMain.add((Component)this.pCenter, "Center");
        this.pMain.add((Component)this.pBar, "Last");
        this.pCenter.add((Component)this.pInstaller, "Last");
        this.pCenter.add((Component)this.pConfig, "Before");
        this.pCenter.add((Component)this.pCli, "Center");
        this.pMain.setVisible(true);
        this.pBar.setVisible(true);
        this.maybeUpdateLauncher();
    }

    public void moveCenter() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getSize().width) / 2;
        int y = (dim.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    protected void maybeUpdateLauncher() {
        Log.debug("maybeUpdateLauncher");
        Config config = this.pConfig.getConfig();
        Installer installer = this.pInstaller.getInstaller();
        if (installer.getState() != Installer.StateValue.NONE) {
            Log.err("Installer busy, State: ", (Object)installer.getState());
            return;
        }
        if (!config.ensureGameDirExists()) {
            Log.err("Cannot create GameDir: " + config.getGameDir());
            return;
        }
        this.showInstallPanel();
        installer.addTask(config.getLauncherChkUrl(), Installer.StateValue.LAUNCHER_CHK);
    }

    private String getReadable(Object o) {
        if (o == null) {
            return "null";
        }
        String suffix = "";
        if (o instanceof JButton) {
            suffix = ": " + ((JButton)o).getText();
        }
        return o.getClass().getSimpleName() + suffix;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Log.debug("MainFrame.actionPerformed evt.source: " + this.getReadable(source));
        if (source == this.bPlay) {
            this.doPlay();
        } else if (source == this.bConfig) {
            this.showConfigPanel();
        } else if (source == this.pConfig) {
            this.hideConfigPanel(e.getActionCommand());
        } else if (source == this.bCli) {
            this.showCliPanel();
        } else if (source == this.pCli) {
            this.hideCliPanel();
        } else if (source == this.bInstall) {
            if ("Update".equals(this.bInstall.getText())) {
                this.doUpdateLauncher();
            } else {
                this.doInstallGameClient();
            }
        } else if (source == this.pInstaller) {
            int id = e.getID();
            Log.debug("MainFrame Action-ID ", id);
            if (id == Installer.StateValue.LAUNCHER.ordinal()) {
                this.hideInstallPanel();
                this.showButtonUpdateLauncher();
            } else if (id == Installer.StateValue.INSTALL.ordinal()) {
                this.doInstallGameClient();
            } else if (id == Installer.StateValue.INSTALLED.ordinal()) {
                boolean b = Boolean.parseBoolean(e.getActionCommand());
                Log.debug("Is Game Already Installed", b);
                this.hideInstallPanel();
                this.updateGameInstalled(b);
            } else if (id == Installer.StateValue.STOP.ordinal()) {
                Log.debug("Stop the Installation");
                this.hideInstallPanel();
            } else if (id == Installer.StateValue.CAN_PLAY.ordinal()) {
                Log.debug("Game Installed! You Can Play!");
                this.hideInstallPanel();
                this.updateGameInstalled(true);
            }
        } else {
            String cmd = e.getActionCommand();
            if ("clearGameDir".equals(cmd)) {
                this.doClearGameDir();
            }
        }
    }

    private void checkIsGameInstalled() {
        boolean b = this.pInstaller.getInstaller().isGameInstalled();
        Log.debug("Game is Installed", b);
        this.updateGameInstalled(b);
    }

    public void showConfigPanel() {
        this.pConfig.restore();
        this.pBar.setVisible(false);
        this.pConfig.setVisible(true);
    }

    public void hideConfigPanel(String cmd) {
        this.pBar.setVisible(true);
        this.pConfig.setVisible(false);
        if ("apply".equals(cmd)) {
            this.checkIsGameInstalled();
        }
    }

    public void showCliPanel() {
        this.pCli.restore();
        this.pBar.setVisible(false);
        this.pCli.setVisible(true);
    }

    public void hideCliPanel() {
        this.pBar.setVisible(true);
        this.pCli.setVisible(false);
    }

    public void showInstallPanel() {
        this.pBar.setVisible(false);
        this.pInstaller.setVisible(true);
    }

    public void hideInstallPanel() {
        this.pBar.setVisible(true);
        this.pInstaller.setVisible(false);
    }

    public void updateGameInstalled(boolean installed) {
        this.bPlay.setEnabled(installed);
        this.bInstall.setEnabled(!installed);
    }

    public void showButtonUpdateLauncher() {
        this.bPlay.setEnabled(false);
        this.bInstall.setEnabled(true);
        this.bInstall.setText("Update");
    }

    public void doInstallGameClient() {
        Log.debug("doInstallGameClient");
        this.showInstallPanel();
        this.pInstaller.start();
    }

    public void doUpdateLauncher() {
        Log.debug("doUpdateLauncher");
        this.showInstallPanel();
        this.pInstaller.startUpdateLauncher();
    }

    public void doPlay() {
        try {
            Log.info("Run Game");
            this.pInstaller.getInstaller().runGame();
        }
        catch (Exception e) {
            GuiUtils.showExceptionMessage(this, e);
            Log.err(e);
        }
    }

    public void doClearGameDir() {
        ArrayList<String> errors = new ArrayList<String>();
        this.pConfig.getConfig().clearGameDir(errors);
        this.updateGameInstalled(false);
        String message = "All files from the Game Directory are Deleted!\n(Except the Settings and the Game Logs at the userdata).\n\nNow you can reinstall the game from scratch.\n";
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cann't Delete this files from the Game Directory:\n");
            sb.append("(Try to close all windows with Game and try again)\n");
            for (String fn : errors) {
                sb.append(fn).append('\n');
            }
            message = sb.toString();
        }
        GuiUtils.show((Component)this, "Clear GameDir", message);
    }
}

