/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.swarg.tonargorn.launcher.utils.BaseUtils;
import org.swarg.tonargorn.launcher.utils.Log;
import org.swarg.tonargorn.launcher.utils.UFileInfo;

public class Updater {
    public static void main(String[] args) {
        try {
            Path oldJar = Paths.get(args[0], new String[0]);
            Thread.sleep(3000L);
            Files.move(oldJar, Paths.get(oldJar + "_bak", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Path newJar = BaseUtils.getSelfJarPath();
            Files.move(newJar, oldJar, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Updated!");
            String cmd = "java -jar " + oldJar;
            System.out.println("Restart updated:" + cmd);
            Runtime.getRuntime().exec(cmd);
            System.exit(0);
        }
        catch (Throwable t) {
            String logFile = (args.length > 0 ? args[0] : "updater") + ".log";
            Updater.log(logFile, t);
        }
    }

    public static boolean update(Path oldJar, UFileInfo uNewJar) {
        Objects.requireNonNull(oldJar, "oldJar");
        Objects.requireNonNull(uNewJar, "uNewJar");
        Objects.requireNonNull(uNewJar.getPath(), "newJarPath");
        Path newJar = Paths.get(uNewJar.getPath(), new String[0]).toAbsolutePath();
        if (!Files.exists(newJar, new LinkOption[0])) {
            Log.err("Not found newJar: " + newJar);
            return false;
        }
        if (!Files.exists(oldJar, new LinkOption[0]) || !Files.isRegularFile(oldJar, new LinkOption[0])) {
            Log.err("Not found replaced oldJar: " + oldJar);
            return false;
        }
        if (oldJar.toAbsolutePath().equals(newJar)) {
            Log.err("Cannot update some file");
            return false;
        }
        try {
            String mainClass = Updater.class.getName();
            String cmd = String.format("java -classpath '%s' %s '%s'", newJar, mainClass, oldJar);
            Log.debug("Command to update & restart: " + cmd);
            Runtime.getRuntime().exec(cmd);
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return true;
    }

    public static void log(String logFile, Throwable t) {
        try (FileWriter fw = new FileWriter(logFile, true);
             PrintWriter pw = new PrintWriter(fw);){
            t.printStackTrace(pw);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

