/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.command;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.swarg.cli.cmd4j.Input;
import org.swarg.cli.cmd4j.Output;
import org.swarg.tonargorn.launcher.Config;

public class ConfCommand {
    protected Config config;

    public ConfCommand(Config config) {
        this.config = config;
    }

    public static void handle(Input q, Output o) {
        ConfCommand handler = new ConfCommand((Config)q.getCtxVar("conf", Config.class));
        q.subcommands().desc("get path to game confign file").cmd("get-path", "gp", handler::getPath).desc("open game-config in the default editor").cmd("open-in-editor", "oie", handler::openInEditor).desc("create the backup copy of current config file").cmd("make-backup", "mb", handler::makeBackup).desc("restore the game config from a previously created backup").cmd("restore-from-backup", "rfb", handler::restoreFromBackup).desc("copy the game config from the old game dir to the current one").cmd("use-from-dir", "ufd", handler::useFromDir).run();
    }

    public void getPath(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        q.validateInput();
        Path path = this.config.getGameSettingsFile();
        boolean exists = Files.exists(path, new LinkOption[0]);
        o.fsay("Current config file[{}]: {}", exists ? "OK" : "NO", path);
    }

    public void openInEditor(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        q.validateInput();
        throw new IllegalStateException("Not implemented yet");
    }

    public void makeBackup(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        q.validateInput();
        Path currConfFile = this.config.getGameSettingsFile();
        if (!Files.exists(currConfFile, new LinkOption[0])) {
            o.error("Not Found Config file: " + currConfFile);
            o.error("Make sure the game are installed to " + this.config.getGameDir());
            return;
        }
        Path backup = this.config.mkFileBackup(currConfFile);
        if (backup == null) {
            o.error("Cannot create backup file for config: " + currConfFile);
            return;
        }
        o.say("Backup Created: " + backup);
    }

    public void restoreFromBackup(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        q.validateInput();
        throw new IllegalStateException("Not implemented yet");
    }

    public void useFromDir(Input q, Output o) {
        String dir = q.desc("directory with config to be used").pullArg();
        q.validateInput();
        q.appendCommandPath(o.sb()).append('\n');
        if (dir.indexOf(File.separator) == -1) {
            dir = Paths.get(this.config.getSoftDir(), dir).toAbsolutePath().toString();
        }
        o.say("Searching for a config file in the dir: " + dir + "...");
        Path currConfFile = this.config.getGameSettingsFile();
        Path newConfFile = this.config.getGameSettingsFile(dir);
        if (!Files.exists(newConfFile, new LinkOption[0]) && !Files.exists(newConfFile = Paths.get(dir, "settings.ron"), new LinkOption[0])) {
            o.error("Config File Not Found: " + newConfFile);
            return;
        }
        if (currConfFile.toString().equals(newConfFile.toString())) {
            o.say("Error: trying to use (copy) the same file");
            return;
        }
        if (Files.exists(currConfFile, new LinkOption[0]) && null == this.config.mkFileBackup(currConfFile)) {
            o.error("Cannot create backup file for current config: " + currConfFile);
            return;
        }
        o.say("Found Config to be used: " + newConfFile);
        o.say("Curret Game Config     : " + currConfFile);
        try {
            Files.copy(newConfFile, currConfFile, StandardCopyOption.REPLACE_EXISTING);
            o.say("Succesful!");
        }
        catch (Exception e) {
            o.error("on copy game config file:");
            e.printStackTrace();
        }
    }
}

