/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.swarg.cli.cmd4j.Input;
import org.swarg.cli.cmd4j.Output;
import org.swarg.tonargorn.launcher.Config;
import org.swarg.tonargorn.launcher.utils.BaseUtils;
import org.swarg.tonargorn.launcher.utils.HTTPDownloadUtil;
import org.swarg.tonargorn.launcher.utils.Log;
import org.swarg.tonargorn.launcher.utils.UFileInfo;

public class DevCommand {
    protected Config config;

    public DevCommand(Config config) {
        this.config = config;
    }

    public static void handle(Input q, Output o) {
        DevCommand handler = new DevCommand((Config)q.getCtxVar("conf", Config.class));
        q.subcommands().desc("check http connection with given url").cmd("check-connection", "cc", handler::checkConnection).desc("remove all files from game direcotry").cmd("clear-gamedir", "cgd", handler::clearGameDir).desc("create a zip archive").cmd("zip", "z", handler::zip).desc("extract files from zip archive").cmd("unzip", "z", handler::unzip).desc("extract files from zip archive").cmd("compare-assets", "z", handler::compareAssets).desc("show process output").cmd("show-process-output", "spo", handler::showProcOutput).run();
    }

    protected void checkConnection(Input q, Output o) {
        String url = q.desc("url").pullArg();
        q.validateInput();
        try {
            HTTPDownloadUtil conn = new HTTPDownloadUtil();
            conn.openConnection(url);
            conn.disconnect();
            o.fsay("done!", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            o.fsay("error:", e.getMessage());
        }
    }

    public void showProcOutput(Input q, Output o) {
        q.appendCommandPath(o.sb().append("\n"));
        Boolean enable = q.desc("enable").pullArgBool();
        q.validateInput();
        this.config.setShowGameOutput(enable);
    }

    protected void clearGameDir(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        q.validateInput();
        ArrayList<String> errors = new ArrayList<String>();
        this.config.clearGameDir(errors);
        if (!errors.isEmpty()) {
            o.append("Cannot delete files:\n");
            for (String fn : errors) {
                o.append(fn).append('\n');
            }
        }
    }

    protected void zip(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        String dir = q.desc("directory to be compressed").pullArg();
        String zip = q.desc("output archive file name").def("a.zip").pullArg();
        q.validateInput();
        if (!dir.contains(File.separator)) {
            dir = this.config.getGameDir() + File.separator + dir;
        }
        if (!zip.contains(File.separator)) {
            zip = this.config.getGameDir() + File.separator + zip;
        }
        boolean b = BaseUtils.zipDir(new File(dir), zip);
        Log.info(zip, b);
    }

    protected void unzip(Input q, Output o) {
        q.appendCommandPath(o.sb()).append('\n');
        String zipFile = q.pullArg();
        q.validateInput();
        if (!zipFile.contains(File.separator)) {
            zipFile = this.config.getGameDir() + File.separator + zipFile;
        }
        BaseUtils.unzip(zipFile, this.config.getGameDir());
    }

    private void compareAssets(Input q, Output o) {
        UFileInfo fi1;
        String name;
        UFileInfo fi3;
        q.appendCommandPath(o.sb().append("\n"));
        String path = q.desc("path").pullArg();
        q.validateInput();
        String dir = this.config.getGameDir() + File.separator + path;
        String fn1 = "assets-linux.chk";
        String fn2 = "assets-win.chk";
        String fn3 = "assets-mac.chk";
        Map<String, UFileInfo> m1 = BaseUtils.parseMd5Files2Map(dir + "/" + fn1);
        Map<String, UFileInfo> m2 = BaseUtils.parseMd5Files2Map(dir + "/" + fn2);
        Map<String, UFileInfo> m3 = BaseUtils.parseMd5Files2Map(dir + "/" + fn3);
        o.append("\n---------------------------------------------------\n");
        o.append("1: ").append(fn1).append(' ').append('\n');
        for (Map.Entry<String, UFileInfo> e : m1.entrySet()) {
            String name1 = e.getKey();
            UFileInfo fi12 = e.getValue();
            UFileInfo fi2 = m2.get(name1);
            fi3 = m3.get(name1);
            if (fi2 == null) {
                o.append("2-: ").append(name1).append('\n');
            } else if (!Arrays.equals(fi12.getMd5(), fi2.getMd5())) {
                o.append("1!2: ").append(name1).append("  ").append(fi12.getMd5Readable()).append("  ").append(fi2.getMd5Readable()).append("\n");
            }
            if (fi3 == null) {
                o.append("3-: ").append(name1).append('\n');
                continue;
            }
            if (Arrays.equals(fi12.getMd5(), fi3.getMd5())) continue;
            o.append("1!3: ").append(name1).append("  ").append(fi12.getMd5Readable()).append("  ").append(fi3.getMd5Readable()).append("\n");
        }
        o.append("\n---------------------------------------------------\n");
        o.append("2: ").append(fn2).append(' ').append('\n');
        for (Map.Entry<String, UFileInfo> e : m2.entrySet()) {
            name = e.getKey();
            UFileInfo fi2 = e.getValue();
            fi1 = m1.get(name);
            fi3 = m3.get(name);
            if (fi1 == null) {
                o.append("1-: ").append(name).append('\n');
            } else if (!Arrays.equals(fi2.getMd5(), fi1.getMd5())) {
                o.append("2!1: ").append(name).append("  ").append(fi2.getMd5Readable()).append("  ").append(fi1.getMd5Readable()).append("\n");
            }
            if (fi3 == null) {
                o.append("3-: ").append(name).append('\n');
                continue;
            }
            if (Arrays.equals(fi2.getMd5(), fi3.getMd5())) continue;
            o.append("2!3: ").append(name).append("  ").append(fi2.getMd5Readable()).append("  ").append(fi3.getMd5Readable()).append("\n");
        }
        o.append("\n---------------------------------------------------\n");
        o.append("3: ").append(fn3).append(' ').append('\n');
        for (Map.Entry<String, UFileInfo> e : m3.entrySet()) {
            name = e.getKey();
            UFileInfo fi32 = e.getValue();
            fi1 = m1.get(name);
            UFileInfo fi2 = m2.get(name);
            if (fi1 == null) {
                o.append("1-: ").append(name).append('\n');
            } else if (!Arrays.equals(fi32.getMd5(), fi1.getMd5())) {
                o.append("3!1: ").append(name).append("  ").append(fi2.getMd5Readable()).append("  ").append(fi1.getMd5Readable()).append("\n");
            }
            if (fi2 == null) {
                o.append("2-: ").append(name).append('\n');
                continue;
            }
            if (Arrays.equals(fi2.getMd5(), fi32.getMd5())) continue;
            o.append("3!2: ").append(name).append("  ").append(fi2.getMd5Readable()).append("  ").append(fi32.getMd5Readable()).append("\n");
        }
        o.append("\n---------------------------------------------------\n");
        o.append("1: ").append(fn1).append(' ').append(m1.size()).append('\n');
        o.append("2: ").append(fn2).append(' ').append(m2.size()).append('\n');
        o.append("3: ").append(fn3).append(' ').append(m3.size()).append('\n');
    }
}

