/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.swarg.tonargorn.launcher.Config;

public class ConfigPanel
extends JPanel
implements ActionListener {
    private Config config;
    private final JLabel lOSArch;
    private final JTextField eGameDir;
    private final JButton bCancel;
    private final JButton bApply;
    private final JButton bChDir;
    private ActionListener pMain;

    public ConfigPanel(ActionListener main, Config config) {
        this.config = config;
        this.pMain = main;
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(0, 8, 8, 96));
        this.lOSArch = new JLabel("OS-Arch");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.lOSArch, gbc);
        JLabel lGameDir = new JLabel("GameDir: ");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)lGameDir, gbc);
        this.eGameDir = new JTextField("");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.eGameDir, gbc);
        this.bChDir = new JButton("?");
        this.bChDir.setPreferredSize(new Dimension(24, 24));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 2, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.bChDir, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.bCancel = new JButton("Cancel");
        this.bCancel.setPreferredSize(new Dimension(144, 32));
        gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(10, 10, 10, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.bCancel, gbc);
        this.bApply = new JButton("Apply");
        this.bApply.setPreferredSize(new Dimension(144, 32));
        gbc = new GridBagConstraints();
        gbc.anchor = 14;
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.insets = new Insets(10, 0, 10, 10);
        gbc.weightx = 1.0;
        this.add((Component)this.bApply, gbc);
        this.setBorder(BorderFactory.createEmptyBorder(144, 40, 0, 40));
        this.bCancel.addActionListener(this);
        this.bApply.addActionListener(this);
        this.bChDir.addActionListener(this);
    }

    public void restore() {
        this.eGameDir.setText(this.config.getGameDir());
        this.lOSArch.setText(this.config.getOSArch());
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bCancel) {
            this.pMain.actionPerformed(new ActionEvent(this, 0, "closed"));
            this.setVisible(false);
        } else if (source == this.bApply) {
            this.applyChanges();
        } else if (source == this.bChDir) {
            this.openFileDialog();
        }
    }

    protected void applyChanges() {
        this.config.setGameDir(this.eGameDir.getText());
        this.config.save();
        this.pMain.actionPerformed(new ActionEvent(this, 0, "apply"));
        this.setVisible(false);
    }

    protected void openFileDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle("Select Directory for Game");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setCurrentDirectory(new File(this.eGameDir.getText()));
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            String dir0 = fileChooser.getSelectedFile() + File.separator + "tonargorn" + File.separator;
            this.eGameDir.setText(dir0);
        }
    }
}

