/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.swarg.tonargorn.launcher.Installer;
import org.swarg.tonargorn.launcher.utils.DownloaderGUI;
import org.swarg.tonargorn.launcher.utils.GuiUtils;
import org.swarg.tonargorn.launcher.utils.UFileInfo;

public class InstallPanel
extends JPanel
implements ActionListener,
DownloaderGUI {
    private ActionListener parent;
    private Installer installer;
    private final JButton bStop;
    private final JTextField lCurrentFile;
    private final JLabel lProgress;
    private JProgressBar progressBar;
    private static final int MINIMUM = 0;
    private static final int MAXIMUM = 100;

    public InstallPanel(ActionListener parent, Installer installer) {
        this.parent = parent;
        this.installer = installer;
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(0, 8, 8, 96));
        JLabel lDownloading = new JLabel("Downloading: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)lDownloading, gbc);
        this.lCurrentFile = new JTextField();
        this.lCurrentFile.setBackground(new Color(0, 16, 16, 96));
        this.lCurrentFile.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 3.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 0, 0, 10);
        this.add((Component)this.lCurrentFile, gbc);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.weightx = 4.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(8, 0, 0, 16);
        this.add((Component)this.progressBar, gbc);
        this.lProgress = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(16, 10, 0, 0);
        gbc.weightx = 1.0;
        this.add((Component)this.lProgress, gbc);
        this.bStop = new JButton("Stop");
        this.bStop.setPreferredSize(new Dimension(144, 32));
        gbc = new GridBagConstraints();
        gbc.anchor = 14;
        gbc.gridwidth = 1;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.insets = new Insets(32, 0, 10, 10);
        gbc.weightx = 1.0;
        this.add((Component)this.bStop, gbc);
        this.setBorder(BorderFactory.createEmptyBorder(64, 40, 0, 40));
        this.bStop.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bStop) {
            this.setVisible(false);
            this.installer.stop();
            this.parent.actionPerformed(new ActionEvent(this, Installer.StateValue.STOP.ordinal(), "stop"));
        }
    }

    public void start() {
        this.installer.start();
    }

    public void startUpdateLauncher() {
        this.installer.startUpdateLauncher();
    }

    public void updateProgressBar(int newValue) {
        this.progressBar.setValue(newValue);
    }

    public Installer getInstaller() {
        return this.installer;
    }

    @Override
    public void show(String message) {
        this.lCurrentFile.setText(message);
    }

    @Override
    public void setFileInfo(String name, int size) {
        this.lCurrentFile.setText(name + " " + String.valueOf(size));
    }

    @Override
    public void progress(Integer progress) {
        this.progressBar.setValue(progress);
    }

    @Override
    public void showError(String message, Throwable err) {
        this.lCurrentFile.setText(message);
        GuiUtils.showExceptionMessage(this, err);
    }

    @Override
    public void done(UFileInfo u, ActionEvent event) {
        String message = u != null ? u.getPath() + "  MD5: " + u.getMd5Readable() : "";
        this.lCurrentFile.setText(message);
        if (event != null) {
            this.parent.actionPerformed(event);
        }
    }
}

