/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.components.cli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import org.swarg.tonargorn.launcher.Config;
import org.swarg.tonargorn.launcher.Console;
import org.swarg.tonargorn.launcher.components.cli.DocFilter;
import org.swarg.tonargorn.launcher.components.cli.UserInput;
import org.swarg.tonargorn.launcher.utils.GuiUtils;
import org.swarg.tonargorn.launcher.utils.Log;

public class CliPanel
extends JPanel
implements ActionListener,
UserInput,
KeyListener {
    private Console cli;
    private boolean canClear;
    private final Config config;
    private final ActionListener pMain;
    private final JTextArea textArea;
    private final JPanel pBar;
    private final JButton bCancel;
    private final JButton bShowLogs;
    private final JButton bClearConsole;
    private final JButton bClearGameDir;
    private int userInputStart = 0;
    private final String CLEAR_GAME_DIR_HINT = "Delete all files from the directory with the Game, except settings";

    public CliPanel(ActionListener main, Config config) {
        this.config = config;
        this.pMain = main;
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(0, 8, 8, 96));
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel l2 = new JLabel("Console");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.weightx = 1.0;
        this.add((Component)l2, gbc);
        this.textArea = new JTextArea(10, 60);
        this.showPrompt();
        this.cli = new Console(config, this::append);
        Font font = this.textArea.getFont();
        if ((float)font.getSize() < 16.0f) {
            this.textArea.setFont(this.textArea.getFont().deriveFont(16.0f));
        }
        ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new DocFilter(this));
        this.textArea.addKeyListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.weightx = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.pBar = new JPanel();
        this.pBar.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.2f));
        this.pBar.setLayout(new FlowLayout(0, 64, 10));
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.weightx = 32.0;
        this.add((Component)this.pBar, gbc);
        this.bCancel = new JButton("Cancel");
        this.bCancel.setPreferredSize(new Dimension(180, 32));
        this.bShowLogs = new JButton("Show Logs");
        this.bShowLogs.setPreferredSize(new Dimension(180, 32));
        this.bShowLogs.setToolTipText("Show the Launcher Logs");
        this.bClearConsole = new JButton("Clear Console");
        this.bClearConsole.setPreferredSize(new Dimension(180, 32));
        this.bClearConsole.setToolTipText("Clear text from the TextArea of Console");
        this.bClearGameDir = new JButton("Clear GameDir");
        this.bClearGameDir.setPreferredSize(new Dimension(180, 32));
        this.bClearGameDir.setToolTipText("Delete all files from the directory with the Game, except settings");
        this.setBorder(BorderFactory.createEmptyBorder(144, 40, 0, 40));
        this.bCancel.addActionListener(this);
        this.bShowLogs.addActionListener(this);
        this.bClearConsole.addActionListener(this);
        this.bClearGameDir.addActionListener(this);
        this.pBar.add(this.bCancel);
        this.pBar.add(this.bShowLogs);
        this.pBar.add(this.bClearConsole);
        this.pBar.add(this.bClearGameDir);
        this.pBar.setVisible(true);
    }

    public void append(String s) {
        this.textArea.append(s);
    }

    public void restore() {
    }

    public Config getConfig() {
        return this.config;
    }

    public Console getConsole() {
        if (this.cli == null) {
            this.cli = new Console(this.config, this.textArea::append);
        }
        return this.cli;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bCancel) {
            this.doClosePanel();
        } else if (source != this.textArea) {
            if (source == this.bClearConsole) {
                this.doClearConsole();
            } else if (source == this.bShowLogs) {
                GuiUtils.show((Component)((Object)this.pMain), "Logs", Log.logList);
            } else if (source == this.bClearGameDir) {
                this.doClearGameDir();
            }
        }
    }

    @Override
    public int getUserInputStart() {
        return this.userInputStart;
    }

    @Override
    public boolean isCanClear() {
        return this.canClear;
    }

    protected void showPrompt() {
        String prompt = "> ";
        this.textArea.append(prompt);
        this.userInputStart = this.textArea.getCaretPosition();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int range = this.textArea.getCaretPosition() - this.userInputStart;
            try {
                String text = this.textArea.getText(this.userInputStart, range).trim();
                this.userInputStart += range;
                if (text.length() > 0) {
                    this.getConsole().handle(text);
                }
                this.showPrompt();
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void doClearConsole() {
        this.canClear = true;
        this.textArea.setText("");
        this.canClear = false;
        this.userInputStart = 0;
        this.showPrompt();
    }

    protected void doClosePanel() {
        this.pMain.actionPerformed(new ActionEvent(this, 0, "closed"));
        this.setVisible(false);
    }

    protected void doClearGameDir() {
        int response = JOptionPane.showConfirmDialog((Component)((Object)this.pMain), "Are you sure you want to delete the all Game files?", "Confirm Deletion", 0);
        if (response != 0) {
            Log.debug("Deletion canceled.");
            return;
        }
        this.doClosePanel();
        this.pMain.actionPerformed(new ActionEvent(this.pMain, 0, "clearGameDir"));
    }
}

