/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.utils;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.swarg.tonargorn.launcher.utils.Log;
import org.swarg.tonargorn.launcher.utils.UFileInfo;

public class BaseUtils {
    private static final int BUFFER_SIZE = 65535;
    public static Map<String, BufferedImage> imgs = new HashMap<String, BufferedImage>();

    public static BufferedImage getLocalImage(String name) {
        try {
            if (imgs.containsKey(name)) {
                return imgs.get(name);
            }
            BufferedImage img = ImageIO.read(BaseUtils.getInternalResource(name));
            imgs.put(name, img);
            Log.info("Opened local image: " + name);
            return img;
        }
        catch (Exception e) {
            Log.err("Fail to open local image", name);
            return BaseUtils.getEmptyImage();
        }
    }

    public static InputStream getInternalResource(String relativePath) throws URISyntaxException, FileNotFoundException {
        relativePath = "/assets/" + relativePath;
        URL location = BaseUtils.class.getProtectionDomain().getCodeSource().getLocation();
        if (BaseUtils.isInJar()) {
            return BaseUtils.class.getResourceAsStream(relativePath);
        }
        return new FileInputStream(new File(location.toURI().getPath().replace("classes/java", "resources") + relativePath));
    }

    public static boolean isInJar() {
        URL location = BaseUtils.class.getProtectionDomain().getCodeSource().getLocation();
        String codeLocation = location.toString();
        return codeLocation.endsWith(".jar") || codeLocation.endsWith(".exe");
    }

    public static BufferedImage getEmptyImage() {
        return new BufferedImage(9, 9, 2);
    }

    public static byte[] hashFile(Path filepath, String algorithm) throws Exception {
        if (algorithm == null || algorithm.isEmpty()) {
            algorithm = "MD5";
        }
        byte[] buffer = new byte[65535];
        MessageDigest md = MessageDigest.getInstance(algorithm);
        try (InputStream is = Files.newInputStream(filepath, new OpenOption[0]);
             DigestInputStream dis = new DigestInputStream(is, md);){
            while (-1 != dis.read(buffer)) {
            }
        }
        return md.digest();
    }

    public static byte[] hashFile2(Path filepath, String algorithm) throws Exception {
        if (algorithm == null || algorithm.isEmpty()) {
            algorithm = "MD5";
        }
        byte[] b = Files.readAllBytes(filepath);
        byte[] hash = MessageDigest.getInstance(algorithm).digest(b);
        return hash;
    }

    public static String ba2s(byte[] ba) {
        return ba == null ? "" : DatatypeConverter.printHexBinary((byte[])ba).toLowerCase();
    }

    public static List<UFileInfo> parseCheckList(File path) {
        try {
            ArrayList<UFileInfo> res = new ArrayList<UFileInfo>();
            List<String> l = Files.readAllLines(path.toPath(), StandardCharsets.UTF_8);
            for (String s : l) {
                if (s == null || s.length() <= 34) continue;
                String md5 = s.substring(0, 33).trim();
                String name = s.substring(34).trim();
                byte[] ba_md5 = DatatypeConverter.parseHexBinary((String)md5);
                res.add(new UFileInfo(name, ba_md5));
            }
            return res;
        }
        catch (IOException e) {
            Log.err(e);
            return null;
        }
    }

    public static boolean isCheckSumsEquals(List<UFileInfo> a, List<UFileInfo> b) {
        if (a == null || b == null || a.isEmpty() || a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            UFileInfo u1 = a.get(i);
            UFileInfo u2 = b.get(i);
            if (u1 == null || u2 == null) {
                return false;
            }
            if (u1.getPath() == null || !u1.getPath().equals(u2.getPath())) {
                return false;
            }
            String md5a = u1.getMd5Readable();
            String md5b = u2.getMd5Readable();
            if (md5a != null && !md5a.isEmpty() && md5a.equals(md5b)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, UFileInfo> parseMd5Files2Map(String path) {
        try {
            HashMap<String, UFileInfo> res = new HashMap<String, UFileInfo>();
            List<String> l = Files.readAllLines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
            for (String s : l) {
                if (s == null || s.length() <= 34) continue;
                String md5 = s.substring(0, 33).trim();
                String name = s.substring(34).trim();
                byte[] ba_md5 = DatatypeConverter.parseHexBinary((String)md5);
                res.put(name, new UFileInfo(name, ba_md5));
            }
            return res;
        }
        catch (IOException e) {
            Log.err(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unzip(String zipFile, String dir) {
        Log.debug("unzip " + zipFile + " into " + dir);
        try (ZipFile zip = new ZipFile(new File(zipFile));){
            String newPath = dir;
            File fdir = new File(newPath);
            if (!fdir.exists()) {
                fdir.mkdirs();
            }
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(newPath, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[65535];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 65535);
                while ((currentByte = is.read(data, 0, 65535)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.err("unzip", e);
            return false;
        }
    }

    public static void addDirToZip(File dir, ZipOutputStream zip, String baseName) throws IOException {
        File[] files = dir.listFiles();
        byte[] buffer = new byte[65535];
        for (File file : files) {
            if (file.isDirectory()) {
                BaseUtils.addDirToZip(file, zip, baseName);
                continue;
            }
            String name = file.getAbsolutePath().substring(baseName.length());
            ZipEntry zipEntry = new ZipEntry(name);
            zip.putNextEntry(zipEntry);
            try (FileInputStream is = new FileInputStream(file);){
                int n;
                while (-1 != (n = ((InputStream)is).read(buffer))) {
                    zip.write(buffer, 0, n);
                }
            }
            zip.closeEntry();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipDir(File dir, String baseName) {
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(baseName));){
            BaseUtils.addDirToZip(dir, zout, baseName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean zipFile(String fileName, String entryName, String baseName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    BaseUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return dir.delete();
    }

    public static boolean createChkFile(String srcPath, File dstFile, String fn) {
        try {
            byte[] ba = BaseUtils.hashFile(Paths.get(srcPath, new String[0]), "MD5");
            if (fn == null) {
                dstFile.getName();
            }
            String line = UFileInfo.getMd5Readable(ba) + "  " + fn;
            Files.write(dstFile.toPath(), line.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Path getSelfJarPath() {
        try {
            URL classUrl = BaseUtils.class.getProtectionDomain().getCodeSource().getLocation();
            Path jarPath = Paths.get(classUrl.toURI()).toAbsolutePath();
            return jarPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

