/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Objects;
import javax.swing.SwingWorker;
import org.swarg.tonargorn.launcher.utils.BaseUtils;
import org.swarg.tonargorn.launcher.utils.DownloaderGUI;
import org.swarg.tonargorn.launcher.utils.HTTPDownloadUtil;
import org.swarg.tonargorn.launcher.utils.Log;
import org.swarg.tonargorn.launcher.utils.UFileInfo;

public class DownloadTask
extends SwingWorker<Void, Void> {
    private static final int BUFFER_SIZE = 65535;
    private static final int BIG = 0x100000;
    private DownloaderGUI gui;
    protected String dstDir;
    protected UFileInfo ufi;

    public DownloadTask(DownloaderGUI gui, String dstDir, UFileInfo ufi) {
        this.gui = gui;
        Objects.requireNonNull(ufi);
        Objects.requireNonNull(ufi.getUrl());
        this.ufi = ufi;
        this.dstDir = dstDir;
        this.ufi.setParent(this);
    }

    @Override
    protected Void doInBackground() throws Exception {
        try {
            this.gui.show("Connection ...");
            HTTPDownloadUtil conn = new HTTPDownloadUtil();
            conn.openConnection(this.ufi.getUrl());
            int fileSz = conn.getFileSize();
            this.gui.setFileInfo(conn.getFileName(), fileSz);
            File dstFile = new File(this.dstDir + File.separator + conn.getFileName());
            this.ufi.setPath(dstFile.toString());
            if (fileSz > 0x100000 && dstFile.exists() && dstFile.length() == (long)fileSz) {
                Log.debug("already downloaded: " + dstFile);
                this.setProgress(50);
                this.ufi.setMd5(BaseUtils.hashFile(dstFile.toPath(), "MD5"));
                this.setProgress(100);
                conn.disconnect();
                return null;
            }
            InputStream inputStream = conn.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(this.ufi.getPath());
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[65535];
            int bytesRead = -1;
            long totalBytesRead = 0L;
            int percentCompleted = 0;
            long fileSize = conn.getFileSize();
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                percentCompleted = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                this.setProgress(percentCompleted);
                md.update(buffer, 0, bytesRead);
                if (!this.isCancelled()) continue;
                Log.info("Cancelled", this.ufi.getPath());
                break;
            }
            this.ufi.setMd5(md.digest());
            outputStream.close();
            conn.disconnect();
        }
        catch (IOException e) {
            Log.err(e);
            this.gui.showError(e.getMessage(), e);
            this.setProgress(0);
            this.cancel(true);
        }
        return null;
    }

    @Override
    protected void done() {
        if (!this.isCancelled()) {
            this.gui.done(this.ufi, null);
        }
    }
}

