/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class GuiUtils {
    public static void showExceptionMessage(Component parent, Throwable t) {
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        JLabel message = new JLabel(t.getMessage());
        message.setBorder(BorderFactory.createEmptyBorder(3, 0, 10, 0));
        JTextArea text = new JTextArea();
        text.setEditable(false);
        text.setFont(UIManager.getFont("Label.font"));
        text.setText(stringWriter.toString().replace("\t", ""));
        text.setCaretPosition(0);
        JScrollPane scroller = new JScrollPane(text);
        scroller.setPreferredSize(new Dimension(600, 200));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)message, "North");
        panel.add((Component)scroller, "South");
        JOptionPane.showMessageDialog(parent, panel, "Exception!", 0);
    }

    public static void show(Component parent, String title, List<String> lines) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
        }
        final String text = sb.toString();
        textArea.setText(text);
        textArea.setCaretPosition(textArea.getDocument().getLength());
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setPreferredSize(new Dimension(800, 400));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JButton button = new JButton("copy to clipboard");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.copyToSystemClipboard(text);
            }
        });
        panel.add((Component)scroller, "North");
        panel.add((Component)button, "South");
        JOptionPane.showMessageDialog(parent, panel, title, 1);
    }

    public static void show(Component parent, String title, String text) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setText(text);
        JOptionPane.showMessageDialog(parent, textArea, title, 1);
    }

    public static void copyToSystemClipboard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(text);
        clipboard.setContents(stringSelection, null);
    }
}

