/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.swarg.tonargorn.launcher.utils.Log;

public class HTTPDownloadUtil {
    public static final String USER_AGENT = "curl/7.74.0";
    public static final String ACCEPT = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9";
    private HttpURLConnection connection;
    private InputStream inputStream;
    private String fileName;
    private int fileSize;

    public void openConnection(String fileURL) throws IOException {
        String contentType;
        String disposition;
        URL url = new URL(fileURL);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setRequestProperty("User-Agent", USER_AGENT);
        this.connection.setRequestProperty("Accept", ACCEPT);
        this.connection.setInstanceFollowRedirects(true);
        this.connection.connect();
        int responseCode = this.connection.getResponseCode();
        if (responseCode == 200) {
            disposition = this.connection.getHeaderField("Content-Disposition");
            contentType = this.connection.getContentType();
            this.fileSize = this.connection.getContentLength();
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > 0) {
                    this.fileName = disposition.substring(index + 10, disposition.length() - 1);
                }
            } else {
                this.fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
            }
        } else {
            if (responseCode == 403) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.connection.getErrorStream()));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    Log.debug(sb.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException("on read ErrorStream", e);
                }
                throw new IOException("Cannot get: " + url + " server say 403-Forbidden");
            }
            throw new IOException("No file to download. Server replied HTTP code: " + responseCode + " url: " + url);
        }
        Log.debug("Content-Type", contentType);
        Log.debug("Content-Disposition", disposition);
        Log.debug("Content-Length", this.fileSize);
        Log.debug("fileName", this.fileName);
        this.inputStream = this.connection.getInputStream();
    }

    public void disconnect() throws IOException {
        this.inputStream.close();
        this.connection.disconnect();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

