/*
 * Decompiled with CFR 0.152.
 */
package org.swarg.tonargorn.launcher.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Log {
    public static final boolean DEBUG = true;
    public static PrintStream out = Log.mkWrappedStdOut();
    public static List<String> logList = new ArrayList<String>();

    public static void debug(Object message) {
        if (message instanceof Throwable) {
            ((Throwable)message).printStackTrace(out);
        } else {
            out.println(message);
        }
    }

    public static void debug(String message, Object e) {
        if (e instanceof Throwable) {
            out.println(message);
            ((Throwable)e).printStackTrace(out);
        } else {
            out.println(message + ": " + e);
        }
    }

    public static void info(Object message) {
        if (message instanceof Throwable) {
            ((Throwable)message).printStackTrace(out);
        } else {
            out.println(message);
        }
    }

    public static void info(String message, Object o) {
        out.println(message + ": " + o);
    }

    public static void err(String message, Object e) {
        if (e instanceof Throwable) {
            out.println(message);
            ((Throwable)e).printStackTrace(out);
        } else {
            out.println(message + ": " + e);
        }
    }

    public static void err(Object e) {
        if (e instanceof Throwable) {
            ((Throwable)e).printStackTrace(out);
        } else {
            out.println(e);
        }
    }

    public static PrintStream mkWrappedStdOut() {
        OutputStream outputStream = new OutputStream(){
            private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public void write(int b) throws IOException {
                this.buffer.write(b);
                if (b == 10) {
                    String line = this.buffer.toString();
                    System.out.print(line);
                    logList.add(line);
                    this.buffer.reset();
                }
            }

            @Override
            public void flush() throws IOException {
                if (this.buffer.size() > 0) {
                    String line = this.buffer.toString();
                    System.out.print(line);
                    logList.add(line);
                    this.buffer.reset();
                }
            }
        };
        PrintStream printStream = new PrintStream(outputStream, true);
        return printStream;
    }
}

